#pragma once

#include "global.h"

#include "GameState.h"
#include "Level.h"



class Sprite;
class Text;

class Editor : public GameState
{

  public:

    Level                 m_Level;

    Sprite*               m_pDimmer;

    int                   m_UnitStartDir;

    int                   m_LevelNr;

    Dobbs::TileType       m_CurTile;

    Dobbs::EntityTypes    m_CurEntity;

    Entity*               m_pCurEntity;
    Entity*               m_pSelectedEntity;

    std::string           m_Entry;

    bool                  m_LevelNameMode;
    bool                  m_TileMode;

    int                   m_BGTileMode;

    bool                  m_MouseReleased;

    int                   m_ExtraDataIndex;


    Editor();


    virtual void          Init();

    virtual void          Exit();

    virtual void          Render();
    virtual void          Update();

    virtual void          OnMouseUpdate( int Buttons, int X, int Y );
    virtual void          OnChar( char Key );
    virtual void          OnKeyDown( char Key );

    void                  ChangeToLevel( int Nr );

    void                  AutoTile();

};
